/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */

import { Signer } from "ethers";
import { Provider, TransactionRequest } from "@ethersproject/providers";
import { Contract, ContractFactory, Overrides } from "@ethersproject/contracts";

import type { PoolManager } from "../PoolManager";

export class PoolManager__factory extends ContractFactory {
  constructor(signer?: Signer) {
    super(_abi, _bytecode, signer);
  }

  deploy(overrides?: Overrides): Promise<PoolManager> {
    return super.deploy(overrides || {}) as Promise<PoolManager>;
  }
  getDeployTransaction(overrides?: Overrides): TransactionRequest {
    return super.getDeployTransaction(overrides || {});
  }
  attach(address: string): PoolManager {
    return super.attach(address) as PoolManager;
  }
  connect(signer: Signer): PoolManager__factory {
    return super.connect(signer) as PoolManager__factory;
  }
  static connect(
    address: string,
    signerOrProvider: Signer | Provider
  ): PoolManager {
    return new Contract(address, _abi, signerOrProvider) as PoolManager;
  }
}

const _abi = [
  {
    inputs: [],
    name: "AlreadyUnlocked",
    type: "error",
  },
  {
    inputs: [],
    name: "ContractUnlocked",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "currency0",
        type: "address",
      },
      {
        internalType: "address",
        name: "currency1",
        type: "address",
      },
    ],
    name: "CurrenciesOutOfOrderOrEqual",
    type: "error",
  },
  {
    inputs: [],
    name: "CurrencyNotSettled",
    type: "error",
  },
  {
    inputs: [],
    name: "DelegateCallNotAllowed",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidCaller",
    type: "error",
  },
  {
    inputs: [],
    name: "ManagerLocked",
    type: "error",
  },
  {
    inputs: [],
    name: "MustClearExactPositiveDelta",
    type: "error",
  },
  {
    inputs: [],
    name: "NonzeroNativeValue",
    type: "error",
  },
  {
    inputs: [],
    name: "PoolNotInitialized",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint24",
        name: "fee",
        type: "uint24",
      },
    ],
    name: "ProtocolFeeTooLarge",
    type: "error",
  },
  {
    inputs: [],
    name: "SwapAmountCannotBeZero",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "int24",
        name: "tickSpacing",
        type: "int24",
      },
    ],
    name: "TickSpacingTooLarge",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "int24",
        name: "tickSpacing",
        type: "int24",
      },
    ],
    name: "TickSpacingTooSmall",
    type: "error",
  },
  {
    inputs: [],
    name: "UnauthorizedDynamicLPFeeUpdate",
    type: "error",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "spender",
        type: "address",
      },
      {
        indexed: true,
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        indexed: false,
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "Approval",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "PoolId",
        name: "id",
        type: "bytes32",
      },
      {
        indexed: true,
        internalType: "address",
        name: "sender",
        type: "address",
      },
      {
        indexed: false,
        internalType: "uint256",
        name: "amount0",
        type: "uint256",
      },
      {
        indexed: false,
        internalType: "uint256",
        name: "amount1",
        type: "uint256",
      },
    ],
    name: "Donate",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "PoolId",
        name: "id",
        type: "bytes32",
      },
      {
        indexed: true,
        internalType: "Currency",
        name: "currency0",
        type: "address",
      },
      {
        indexed: true,
        internalType: "Currency",
        name: "currency1",
        type: "address",
      },
      {
        indexed: false,
        internalType: "uint24",
        name: "fee",
        type: "uint24",
      },
      {
        indexed: false,
        internalType: "int24",
        name: "tickSpacing",
        type: "int24",
      },
      {
        indexed: false,
        internalType: "contract IHooks",
        name: "hooks",
        type: "address",
      },
      {
        indexed: false,
        internalType: "uint160",
        name: "sqrtPriceX96",
        type: "uint160",
      },
      {
        indexed: false,
        internalType: "int24",
        name: "tick",
        type: "int24",
      },
    ],
    name: "Initialize",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "PoolId",
        name: "id",
        type: "bytes32",
      },
      {
        indexed: true,
        internalType: "address",
        name: "sender",
        type: "address",
      },
      {
        indexed: false,
        internalType: "int24",
        name: "tickLower",
        type: "int24",
      },
      {
        indexed: false,
        internalType: "int24",
        name: "tickUpper",
        type: "int24",
      },
      {
        indexed: false,
        internalType: "int256",
        name: "liquidityDelta",
        type: "int256",
      },
      {
        indexed: false,
        internalType: "bytes32",
        name: "salt",
        type: "bytes32",
      },
    ],
    name: "ModifyLiquidity",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "operator",
        type: "address",
      },
      {
        indexed: false,
        internalType: "bool",
        name: "approved",
        type: "bool",
      },
    ],
    name: "OperatorSet",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "address",
        name: "user",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "newOwner",
        type: "address",
      },
    ],
    name: "OwnershipTransferred",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "address",
        name: "protocolFeeController",
        type: "address",
      },
    ],
    name: "ProtocolFeeControllerUpdated",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "PoolId",
        name: "id",
        type: "bytes32",
      },
      {
        indexed: false,
        internalType: "uint24",
        name: "protocolFee",
        type: "uint24",
      },
    ],
    name: "ProtocolFeeUpdated",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        internalType: "PoolId",
        name: "id",
        type: "bytes32",
      },
      {
        indexed: true,
        internalType: "address",
        name: "sender",
        type: "address",
      },
      {
        indexed: false,
        internalType: "int128",
        name: "amount0",
        type: "int128",
      },
      {
        indexed: false,
        internalType: "int128",
        name: "amount1",
        type: "int128",
      },
      {
        indexed: false,
        internalType: "uint160",
        name: "sqrtPriceX96",
        type: "uint160",
      },
      {
        indexed: false,
        internalType: "uint128",
        name: "liquidity",
        type: "uint128",
      },
      {
        indexed: false,
        internalType: "int24",
        name: "tick",
        type: "int24",
      },
      {
        indexed: false,
        internalType: "uint24",
        name: "fee",
        type: "uint24",
      },
    ],
    name: "Swap",
    type: "event",
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: false,
        internalType: "address",
        name: "caller",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "from",
        type: "address",
      },
      {
        indexed: true,
        internalType: "address",
        name: "to",
        type: "address",
      },
      {
        indexed: true,
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        indexed: false,
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "Transfer",
    type: "event",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        internalType: "address",
        name: "spender",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "allowance",
    outputs: [
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "spender",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "approve",
    outputs: [
      {
        internalType: "bool",
        name: "",
        type: "bool",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
    ],
    name: "balanceOf",
    outputs: [
      {
        internalType: "uint256",
        name: "balance",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "from",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "burn",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "clear",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "recipient",
        type: "address",
      },
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "collectProtocolFees",
    outputs: [
      {
        internalType: "uint256",
        name: "amountCollected",
        type: "uint256",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "key",
        type: "tuple",
      },
      {
        internalType: "uint256",
        name: "amount0",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amount1",
        type: "uint256",
      },
      {
        internalType: "bytes",
        name: "hookData",
        type: "bytes",
      },
    ],
    name: "donate",
    outputs: [
      {
        internalType: "BalanceDelta",
        name: "delta",
        type: "int256",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes32",
        name: "slot",
        type: "bytes32",
      },
    ],
    name: "extsload",
    outputs: [
      {
        internalType: "bytes32",
        name: "",
        type: "bytes32",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes32",
        name: "startSlot",
        type: "bytes32",
      },
      {
        internalType: "uint256",
        name: "nSlots",
        type: "uint256",
      },
    ],
    name: "extsload",
    outputs: [
      {
        internalType: "bytes32[]",
        name: "",
        type: "bytes32[]",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes32[]",
        name: "slots",
        type: "bytes32[]",
      },
    ],
    name: "extsload",
    outputs: [
      {
        internalType: "bytes32[]",
        name: "",
        type: "bytes32[]",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes32[]",
        name: "slots",
        type: "bytes32[]",
      },
    ],
    name: "exttload",
    outputs: [
      {
        internalType: "bytes32[]",
        name: "",
        type: "bytes32[]",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes32",
        name: "slot",
        type: "bytes32",
      },
    ],
    name: "exttload",
    outputs: [
      {
        internalType: "bytes32",
        name: "",
        type: "bytes32",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "key",
        type: "tuple",
      },
      {
        internalType: "uint160",
        name: "sqrtPriceX96",
        type: "uint160",
      },
    ],
    name: "initialize",
    outputs: [
      {
        internalType: "int24",
        name: "tick",
        type: "int24",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "owner",
        type: "address",
      },
      {
        internalType: "address",
        name: "operator",
        type: "address",
      },
    ],
    name: "isOperator",
    outputs: [
      {
        internalType: "bool",
        name: "isOperator",
        type: "bool",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "to",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "mint",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "key",
        type: "tuple",
      },
      {
        components: [
          {
            internalType: "int24",
            name: "tickLower",
            type: "int24",
          },
          {
            internalType: "int24",
            name: "tickUpper",
            type: "int24",
          },
          {
            internalType: "int256",
            name: "liquidityDelta",
            type: "int256",
          },
          {
            internalType: "bytes32",
            name: "salt",
            type: "bytes32",
          },
        ],
        internalType: "struct IPoolManager.ModifyLiquidityParams",
        name: "params",
        type: "tuple",
      },
      {
        internalType: "bytes",
        name: "hookData",
        type: "bytes",
      },
    ],
    name: "modifyLiquidity",
    outputs: [
      {
        internalType: "BalanceDelta",
        name: "callerDelta",
        type: "int256",
      },
      {
        internalType: "BalanceDelta",
        name: "feesAccrued",
        type: "int256",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [],
    name: "owner",
    outputs: [
      {
        internalType: "address",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [],
    name: "protocolFeeController",
    outputs: [
      {
        internalType: "contract IProtocolFeeController",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
    ],
    name: "protocolFeesAccrued",
    outputs: [
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "operator",
        type: "address",
      },
      {
        internalType: "bool",
        name: "approved",
        type: "bool",
      },
    ],
    name: "setOperator",
    outputs: [
      {
        internalType: "bool",
        name: "",
        type: "bool",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "key",
        type: "tuple",
      },
      {
        internalType: "uint24",
        name: "newProtocolFee",
        type: "uint24",
      },
    ],
    name: "setProtocolFee",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "contract IProtocolFeeController",
        name: "controller",
        type: "address",
      },
    ],
    name: "setProtocolFeeController",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [],
    name: "settle",
    outputs: [
      {
        internalType: "uint256",
        name: "",
        type: "uint256",
      },
    ],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "recipient",
        type: "address",
      },
    ],
    name: "settleFor",
    outputs: [
      {
        internalType: "uint256",
        name: "",
        type: "uint256",
      },
    ],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes4",
        name: "interfaceId",
        type: "bytes4",
      },
    ],
    name: "supportsInterface",
    outputs: [
      {
        internalType: "bool",
        name: "",
        type: "bool",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "key",
        type: "tuple",
      },
      {
        components: [
          {
            internalType: "bool",
            name: "zeroForOne",
            type: "bool",
          },
          {
            internalType: "int256",
            name: "amountSpecified",
            type: "int256",
          },
          {
            internalType: "uint160",
            name: "sqrtPriceLimitX96",
            type: "uint160",
          },
        ],
        internalType: "struct IPoolManager.SwapParams",
        name: "params",
        type: "tuple",
      },
      {
        internalType: "bytes",
        name: "hookData",
        type: "bytes",
      },
    ],
    name: "swap",
    outputs: [
      {
        internalType: "BalanceDelta",
        name: "swapDelta",
        type: "int256",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
    ],
    name: "sync",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
      {
        internalType: "address",
        name: "to",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "take",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "receiver",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "transfer",
    outputs: [
      {
        internalType: "bool",
        name: "",
        type: "bool",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "sender",
        type: "address",
      },
      {
        internalType: "address",
        name: "receiver",
        type: "address",
      },
      {
        internalType: "uint256",
        name: "id",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amount",
        type: "uint256",
      },
    ],
    name: "transferFrom",
    outputs: [
      {
        internalType: "bool",
        name: "",
        type: "bool",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "address",
        name: "newOwner",
        type: "address",
      },
    ],
    name: "transferOwnership",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes",
        name: "data",
        type: "bytes",
      },
    ],
    name: "unlock",
    outputs: [
      {
        internalType: "bytes",
        name: "result",
        type: "bytes",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        components: [
          {
            internalType: "Currency",
            name: "currency0",
            type: "address",
          },
          {
            internalType: "Currency",
            name: "currency1",
            type: "address",
          },
          {
            internalType: "uint24",
            name: "fee",
            type: "uint24",
          },
          {
            internalType: "int24",
            name: "tickSpacing",
            type: "int24",
          },
          {
            internalType: "contract IHooks",
            name: "hooks",
            type: "address",
          },
        ],
        internalType: "struct PoolKey",
        name: "key",
        type: "tuple",
      },
      {
        internalType: "uint24",
        name: "newDynamicLPFee",
        type: "uint24",
      },
    ],
    name: "updateDynamicLPFee",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
];

const _bytecode =
  "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";
